/********************************************************************************/
/*																				*/
/*	Kroenke and Auer - Database Concepts (8th Edition) Chapters 06, 07, 08		*/
/*																				*/
/*	Marcia's Dry Cleaning Case 				 									*/
/*																				*/
/*	MySQL 5.7 code solutions													*/
/*																				*/
/********************************************************************************/


/*****   Case Question  7.E   ***************************************************/

ALTER TABLE INVOICE 
	ADD	Status		Char(12)	NULL;
    
/* MySQL does not enforce CHECK constraints */
ALTER TABLE INVOICE 
	ADD	CONSTRAINT	StatusValueCheck	CHECK
		(Status IN ('Waiting', 'In-process', 'Finished', 'Pending'));

UPDATE INVOICE
	SET  	Status = 'Finished'
	WHERE	DateOut IS NOT NULL;

UPDATE INVOICE
	SET  	Status = 'In-Process'
	WHERE	DateOut IS NULL;

SELECT * FROM INVOICE;

/*****   Project Question  7.F   ************************************************/
/******  Create View  ***********************************************************/

CREATE VIEW 	CustomerInvoiceView AS
	SELECT 		C.LastName, C.FirstName, C.Phone, I.InvoiceNumber,
				I.DateIn, DateOut, I.TotalAmount, I.Status
	FROM 		CUSTOMER AS C, INVOICE AS I
	WHERE		C.CustomerID = I.CustomerID;

/******  Insert New Data ********************************************************/

SELECT * FROM INVOICE;

INSERT INTO INVOICE VALUES(
		2017010, 110, '2017-10-14', NULL, 7.00, 0.55, 7.55, 'In-process');
INSERT INTO INVOICE VALUES(
		2017011, 130, '2017-10-15', NULL, 140.50, 11.10, 151.60, 'In-process');
INSERT INTO INVOICE VALUES(
		2017012, 120, '2017-10-17', NULL, 27.00, 2.13, 29.13, 'Waiting');

INSERT INTO INVOICE_ITEM VALUES(2017010, 1, 16, 2,  3.50, 7.00);
INSERT INTO INVOICE_ITEM VALUES(2017011, 1, 16, 3,  3.50, 10.50);
INSERT INTO INVOICE_ITEM VALUES(2017011, 2, 11, 12, 2.50, 30.00);
INSERT INTO INVOICE_ITEM VALUES(2017011, 3, 20, 8,  5.00, 40.00);
INSERT INTO INVOICE_ITEM VALUES(2017011, 4, 25, 10, 6.00, 60.00);
INSERT INTO INVOICE_ITEM VALUES(2017012, 1, 40, 3,  9.00, 27.00);

/******  Query View *************************************************************/

SELECT * FROM CustomerInvoiceView;

/********************************************************************************/













